/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.crafting.lib.reactivex.rxjava3.internal.operators.flowable;

import dev.compactmods.crafting.lib.reactivestreams.Subscriber;
import dev.compactmods.crafting.lib.reactivestreams.Subscription;
import dev.compactmods.crafting.lib.reactivex.rxjava3.core.Flowable;
import dev.compactmods.crafting.lib.reactivex.rxjava3.core.FlowableSubscriber;
import dev.compactmods.crafting.lib.reactivex.rxjava3.exceptions.CompositeException;
import dev.compactmods.crafting.lib.reactivex.rxjava3.exceptions.Exceptions;
import dev.compactmods.crafting.lib.reactivex.rxjava3.functions.Predicate;
import dev.compactmods.crafting.lib.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import dev.compactmods.crafting.lib.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;

public final class FlowableOnErrorComplete<T>
extends AbstractFlowableWithUpstream<T, T> {
    final Predicate<? super Throwable> predicate;

    public FlowableOnErrorComplete(Flowable<T> source, Predicate<? super Throwable> predicate) {
        super(source);
        this.predicate = predicate;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> observer) {
        this.source.subscribe(new OnErrorCompleteSubscriber<T>(observer, this.predicate));
    }

    public static final class OnErrorCompleteSubscriber<T>
    implements FlowableSubscriber<T>,
    Subscription {
        final Subscriber<? super T> downstream;
        final Predicate<? super Throwable> predicate;
        Subscription upstream;

        public OnErrorCompleteSubscriber(Subscriber<? super T> actual, Predicate<? super Throwable> predicate) {
            this.downstream = actual;
            this.predicate = predicate;
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.upstream, s)) {
                this.upstream = s;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T value) {
            this.downstream.onNext(value);
        }

        @Override
        public void onError(Throwable e) {
            boolean b;
            try {
                b = this.predicate.test(e);
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                this.downstream.onError(new CompositeException(e, ex));
                return;
            }
            if (b) {
                this.downstream.onComplete();
            } else {
                this.downstream.onError(e);
            }
        }

        @Override
        public void onComplete() {
            this.downstream.onComplete();
        }

        @Override
        public void cancel() {
            this.upstream.cancel();
        }

        @Override
        public void request(long n) {
            this.upstream.request(n);
        }
    }
}

